import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class RulerClock extends PApplet {

int h0;
int h1;
int h2;
int h3;
int h4;
int h5;
int h6;
int h7;
int h8;
int h9;
int h10;
int h11;

public void setup() {
  
  background(0xff001C21);
}

public void draw() {
  /* implement each function.
   this order guarantee that the important indicator
   will not be hided. i.e. the minuteTime method
   was written before secondTime(), otherwise the
   indicator of secondTime will be hided by
   minuteTime.*/

  minuteTime();
  secondTime();
  hourTime();

  //minute ruler
  for (int i = 0; i < 60; i ++)
  {
    stroke(0xff00D2FF);
    line(77, 0+8.47f*i, 78, 0+8.47f*i);
    line(800-77, 0+8.47f*i, 800-78, 0+8.47f*i);
  }

  //second ruler
  for (int i = 0; i < 60; i ++)
  {
    stroke(0xff00D2FF);
    line(105+10*i, 245, 105+10*i, 255);
  }
}

public void secondTime() {
  int sec = second();
  //set a variable that saves the sdecond value

  //Initialize the rectangle
  noFill();
  stroke(0xff00667C);
  rect(105, 85, 590, 330);

  //indicate the second
  fill(0xff00667C);
  rect(105, 85, 10*sec, 330);
  
  /*If one minute is done and the value of min is
  back to 0, the second indicator will be refreshed
  by re-draw the rectangle.
  The moment of "0 second" will be a rectangle
  that the color is exactly 
  and is the same as the default background.
  Then, the rectangle will return to noFill() and looks
  like it is transparent.*/
  if (sec == 0) {
    fill(0xff001C21);
    stroke(0xff00667C);
    rect(105, 85, 590, 330);
  }
}

public void minuteTime() {
  //int min = second();//just for test
  int min = minute();
  //set a variable that saves the minute value

  //The method of thinking is basically the same as
  //the secondTime() function.
  
  noFill();
  noStroke();
  rect(0, 0, 800, 500);

  fill(0xff00313B);
  rect(0, 0, 800, (8.47f)*min);
  
  if (min == 0) {
    fill(0xff001C21);
    //the color is the same as the default background.
    noStroke();
    rect(0, 0, 800, 500);
  }
}


public void hourTime() {
  /*For graphic design necessary, 
   this part of code is a bit long.*/

  int hr = hour();
  //set a variable that saves the hour value

  noStroke();

  //for each particular hour,
  //set colors that indicated active or inactive
  if (hr == 0 || hr == 12) {
    h0 = 0xff00CEFF;
  } else {
    h0 = 0xff00596F;
  }

  if (hr == 1 || hr == 13) {
    h1 = 0xff00CEFF;
  } else {
    h1 = 0xff00596F;
  }

  if (hr == 2 || hr == 14) {
    h2 = 0xff00CEFF;
  } else {
    h2 = 0xff00596F;
  }

  if (hr == 3 || hr == 15) {
    h3 = 0xff00CEFF;
  } else {
    h3 = 0xff00596F;
  }

  if (hr == 4 || hr == 16) {
    h4 = 0xff00CEFF;
  } else {
    h4 = 0xff00596F;
  }

  if (hr == 5 || hr == 17) {
    h5 = 0xff00CEFF;
  } else {
    h5 = 0xff00596F;
  }

  if (hr == 6 || hr == 18) {
    h6 = 0xff00CEFF;
  } else {
    h6 = 0xff00596F;
  }

  if (hr == 7 || hr == 19) {
    h7 = 0xff00CEFF;
  } else {
    h7 = 0xff00596F;
  }

  if (hr == 8 || hr == 20) {
    h8 = 0xff00CEFF;
  } else {
    h8 = 0xff00596F;
  }

  if (hr == 9 || hr == 21) {
    h9 = 0xff00CEFF;
  } else {
    h9 = 0xff00596F;
  }

  if (hr == 10 || hr == 22) {
    h10 = 0xff00CEFF;
  } else {
    h10 = 0xff00596F;
  }

  if (hr == 11 || hr == 23) {
    h11 = 0xff00CEFF;
  } else {
    h11 = 0xff00596F;
  }

  //draw each hour rectangle bhy filling particular color

  fill(h0);
  rect(350, 0, 100, 50);//12(0)

  fill(h1);
  rect(550, 0, 100, 50);//1

  fill(h2);
  rect(750, 85, 50, 80);//2

  fill(h3);
  rect(750, 210, 50, 80);//3

  fill(h4);
  rect(750, 335, 50, 80);//4

  fill(h5);
  rect(550, 450, 100, 50);//5

  fill(h6);
  rect(350, 450, 100, 50);//6

  fill(h7);
  rect(150, 450, 100, 50);//7

  fill(h8);
  rect(0, 335, 50, 80);//8

  fill(h9);
  rect(0, 210, 50, 80);//9

  fill(h10);
  rect(0, 85, 50, 80);//10

  fill(h11);
  rect(150, 0, 100, 50);//11
}

//Copyright (c) 2016 Junshu Liu.
//RulerClock 1.0
  public void settings() {  size(800, 500); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "RulerClock" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
